<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NewNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $body;        // full HTML from generateEmailContent()
    public $subjectLine; // subject of the email
    public $recipient;   // receiver's name
    public $url;         // tracking link
    public $attachment;  // optional file

    public function __construct($body, $subjectLine, $recipient, $url = null, $attachment = null)
    {
        $this->body = $body;
        $this->subjectLine = $subjectLine;
        $this->recipient = $recipient;
        $this->url = $url;
        $this->attachment = $attachment;
    }

    public function build()
    {
        $email = $this->subject($this->subjectLine)
                      ->html($this->body); // ✅ render HTML directly

        if ($this->attachment) {
            $email->attach($this->attachment);
        }

        return $email;
    }
}
